<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profile_edit_requests', function (Blueprint $table) {
            $table->id();           
            $table->bigInteger('user');
            $table->bigInteger('customer');
            $table->string('email')->nullable();
            $table->string('mobile')->nullable();; 
            $table->longText('company_details')->nullable();;
            $table->longText('others')->nullable();;
            $table->tinyInteger('viewed')->default(0);
            $table->tinyInteger('completed')->default(0);
            $table->tinyInteger('active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profile_edit_requests');
    }
};
