<!DOCTYPE html>

<html>

<head>
	<title></title>

	<meta content="" name="description" />
	<meta charset="utf-8" />
	<meta content="width=device-width" name="viewport" />
	<link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet" type="text/css" />
	<style>
		.bee-row,
		.bee-row-content {
			position: relative
		}

		.bee-row-10,
		.bee-row-10 .bee-row-content {
			background-repeat: no-repeat;
			background-size: auto
		}

		body {
			background-color: #FFFFFF;
			color: #000000;
			font-family: Lato, Tahoma, Verdana, Segoe, sans-serif
		}

		a {
			color: #0068A5
		}

		* {
			box-sizing: border-box
		}

		body,
		h1,
		p {
			margin: 0
		}

		.bee-row-content {
			max-width: 955px;
			margin: 0 auto;
			display: flex
		}

		.bee-row-content .bee-col-w3 {
			flex-basis: 25%
		}

		.bee-row-content .bee-col-w4 {
			flex-basis: 33%
		}

		.bee-row-content .bee-col-w5 {
			flex-basis: 42%
		}

		.bee-row-content .bee-col-w6 {
			flex-basis: 50%
		}

		.bee-row-content .bee-col-w7 {
			flex-basis: 58%
		}

		.bee-row-content .bee-col-w12 {
			flex-basis: 100%
		}

		.bee-icon .bee-icon-label-right a {
			text-decoration: none
		}

		.bee-divider,
		.bee-image {
			overflow: auto
		}

		.bee-divider .center,
		.bee-image .bee-center {
			margin: 0 auto
		}

		.bee-divider .right {
			float: right
		}

		.bee-row-9 .bee-col-1 .bee-block-1 {
			width: 100%
		}

		.bee-icon {
			display: inline-block;
			vertical-align: middle
		}

		.bee-icon .bee-content {
			display: flex;
			align-items: center
		}

		.bee-image img {
			display: block;
			width: 100%
		}

		.bee-paragraph,
		.bee-text {
			overflow-wrap: anywhere
		}

		.bee-social .icon img {
			max-height: 32px
		}

		.bee-table table {
			border-collapse: collapse;
			width: 100%
		}

		.bee-table table tbody,
		.bee-table table thead {
			vertical-align: top
		}

		.bee-table table td,
		.bee-table table th {
			padding: 10px;
			word-break: break-word
		}

		@media (max-width:768px) {
			.bee-row-content:not(.no_stack) {
				display: block
			}
		}

		.bee-row-1,
		.bee-row-2,
		.bee-row-3,
		.bee-row-4,
		.bee-row-5,
		.bee-row-6,
		.bee-row-7,
		.bee-row-8,
		.bee-row-9 {
			background-repeat: no-repeat
		}

		.bee-row-1 .bee-row-content,
		.bee-row-2 .bee-row-content,
		.bee-row-9 .bee-row-content {
			background-repeat: no-repeat;
			border-radius: 0;
			color: #000000
		}

		.bee-row-1 .bee-col-1,
		.bee-row-12 .bee-col-1,
		.bee-row-2 .bee-col-1,
		.bee-row-4 .bee-col-3,
		.bee-row-7 .bee-col-2,
		.bee-row-9 .bee-col-1 {
			padding-bottom: 5px;
			padding-top: 5px
		}

		.bee-row-1 .bee-col-1 .bee-block-1,
		.bee-row-5 .bee-col-1 .bee-block-1,
		.bee-row-7 .bee-col-1 .bee-block-1,
		.bee-row-7 .bee-col-2 .bee-block-1 {
			padding: 10px
		}

		.bee-row-3 .bee-row-content,
		.bee-row-4 .bee-row-content,
		.bee-row-5 .bee-row-content,
		.bee-row-6 .bee-row-content,
		.bee-row-7 .bee-row-content,
		.bee-row-8 .bee-row-content {
			background-color: #e3e3e3;
			background-repeat: no-repeat;
			color: #000000
		}

		.bee-row-4 .bee-col-1 .bee-block-1 {
			padding: 10px;
			width: 100%
		}

		.bee-row-4 .bee-col-2 .bee-block-1 {
			padding: 10px;
			text-align: center;
			width: 100%
		}

		.bee-row-4 .bee-col-2 .bee-block-2 {
			padding-left: 10px;
			padding-right: 10px
		}

		.bee-row-4 .bee-col-3 .bee-block-1 {
			padding-left: 15px;
			padding-right: 10px
		}

		.bee-row-10 .bee-col-2 .bee-block-1,
		.bee-row-11 .bee-col-1 .bee-block-1,
		.bee-row-11 .bee-col-3 .bee-block-1,
		.bee-row-6 .bee-col-1 .bee-block-2,
		.bee-row-8 .bee-col-1 .bee-block-1 {
			padding: 10px 20px
		}

		.bee-row-10 .bee-row-content {
			border-radius: 4px;
			color: #000000
		}

		.bee-row-10 .bee-col-1 .bee-block-1 {
			padding: 10px 20px 20px
		}

		.bee-row-10 .bee-col-3 .bee-block-1 {
			padding: 10px 20px 30px
		}

		.bee-row-10 .bee-col-4 .bee-block-1 {
			padding: 10px;
			text-align: center
		}

		.bee-row-11 {
			background-color: #e3e3e3;
			background-repeat: no-repeat
		}

		.bee-row-12,
		.bee-row-12 .bee-row-content {
			background-color: #ffffff;
			background-repeat: no-repeat
		}

		.bee-row-11 .bee-row-content {
			background-repeat: no-repeat;
			color: #000000
		}

		.bee-row-12 .bee-row-content {
			color: #000000
		}

		.bee-row-12 .bee-col-1 .bee-block-1 {
			color: #1e0e4b;
			font-family: Inter, sans-serif;
			font-size: 15px;
			padding-bottom: 5px;
			padding-top: 5px;
			text-align: center
		}

		.bee-row-1 .bee-col-1 .bee-block-1 {
			color: #101112;
			direction: ltr;
			font-size: 16px;
			font-weight: 400;
			letter-spacing: 0;
			line-height: 120%;
			text-align: left
		}

		.bee-row-1 .bee-col-1 .bee-block-1 a,
		.bee-row-4 .bee-col-2 .bee-block-2 a {
			color: #7747FF
		}

		.bee-row-1 .bee-col-1 .bee-block-1 p:not(:last-child),
		.bee-row-4 .bee-col-2 .bee-block-2 p:not(:last-child) {
			margin-bottom: 16px
		}

		.bee-row-4 .bee-col-2 .bee-block-2 {
			color: #101112;
			direction: ltr;
			font-size: 18px;
			font-weight: 700;
			letter-spacing: 0;
			line-height: 120%;
			text-align: center
		}

		.bee-row-10 .bee-col-1 .bee-block-1 {
			color: #000000;
			font-size: 20px;
			line-height: 120%;
			text-align: left
		}

		.bee-row-10 .bee-col-1 .bee-block-1 a,
		.bee-row-10 .bee-col-2 .bee-block-1 a,
		.bee-row-10 .bee-col-3 .bee-block-1 a {
			color: #000000
		}

		.bee-row-10 .bee-col-1 .bee-block-1 p:not(:last-child),
		.bee-row-10 .bee-col-2 .bee-block-1 p:not(:last-child),
		.bee-row-10 .bee-col-3 .bee-block-1 p:not(:last-child),
		.bee-row-11 .bee-col-1 .bee-block-1 p:not(:last-child) {
			margin-bottom: undefined
		}

		.bee-row-10 .bee-col-2 .bee-block-1,
		.bee-row-10 .bee-col-3 .bee-block-1 {
			color: #000000;
			font-size: 14px;
			line-height: 120%;
			text-align: left
		}

		.bee-row-11 .bee-col-1 .bee-block-1 {
			color: #000000;
			font-size: 11px;
			line-height: 120%;
			text-align: left
		}

		.bee-row-11 .bee-col-1 .bee-block-1 a {
			color: #ffffff
		}

		.bee-row-12 .bee-col-1 .bee-block-1 .bee-icon-image {
			padding: 5px 6px 5px 5px
		}

		.bee-row-12 .bee-col-1 .bee-block-1 .bee-icon:not(.bee-icon-first) .bee-content {
			margin-left: 0
		}

		.bee-row-12 .bee-col-1 .bee-block-1 .bee-icon::not(.bee-icon-last) .bee-content {
			margin-right: 0
		}
	</style>
</head>

<body>
	<div class="bee-page-container">
		<div class="bee-row bee-row-1">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-paragraph">
						<div class="spacer" style="height:10px;"></div>
						<p>Dear <b> {{$data['customerData']->name}} </b>,</p>
						<div class="spacer" style="height:10px;"></div>
						<div class="spacer" style="height:10px;"></div>
						<p>We are pleased to confirm that your order # {{$data['orderHeader']->rp_order_id}} has been successfully received and is now being processed. Below are the details of your order</p>

					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-2">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-spacer">
						<div class="spacer" style="height:20px;"></div>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-3">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-spacer">
						<div class="spacer" style="height:20px;"></div>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-4">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w3">
					<div class="bee-block bee-block-1 bee-image"><img alt="" class="bee-fixedwidth" src="{{ asset('/images/email/mayarimages/logo.png') }}" style="max-width:95px;" /></div>
				</div>
				<div class="bee-col bee-col-2 bee-col-w6">
					<div class="bee-block bee-block-1 bee-heading">
						<h1 style="color:#9561a9;direction:ltr;font-family:Lato, Tahoma, Verdana, Segoe, sans-serif;font-size:32px;font-weight:700;letter-spacing:normal;line-height:120%;text-align:center;margin-top:0;margin-bottom:0;">
							<span class="tinyMce-placeholder">Mayar Connect Order</span>
						</h1>
					</div>
					<div class="bee-block bee-block-2 bee-paragraph">
						<p>Order No: #{{$data['orderHeader']->rp_order_id}}</p>
					</div>
				</div>
				<div class="bee-col bee-col-3 bee-col-w3">
					<div class="bee-block bee-block-1 bee-table">
						<table style="table-layout:fixed;direction:ltr;background-color:transparent;font-family:Lato, Tahoma, Verdana, Segoe, sans-serif;font-weight:700;color:#121212;text-align:left;letter-spacing:0px;">
							<tbody style="font-size:14px;line-height:120%;">
								<tr>
									<td style="border-top:0px solid transparent;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;">
										Order Date</td>
									<td style="border-top:0px solid transparent;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;">
										{{$data['orderHeader']->order_date}}
									</td>
								</tr>

								<tr>
									<td style="border-top:0px solid transparent;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;">
										Order Status</td>
									<td style="border-top:0px solid transparent;border-right:0px solid transparent;border-bottom:0px solid transparent;border-left:0px solid transparent;">
										<span class="tinyMce-placeholder" style="color: #fff;background: #09b963;padding: 5px;border-radius: 8px;">Confirmed</span>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-5">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-table">
						<table style="table-layout:fixed;direction:ltr;background-color:transparent;font-family:Lato, Tahoma, Verdana, Segoe, sans-serif;font-weight:400;color:#000000;text-align:left;letter-spacing:0px;">
							<thead style="background-color:#EAEAEA;color:#505659;font-size:12px;line-height:120%;text-align:left;">
								<tr>
								<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;">
										Code</th>
									<th width="25%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;">
										Product</th>
									<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;">
										UOM</th>
									<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
										Unit Price</th>
									<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: center;">
										Quantity</th>
									<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
										Total Amount </th>
									<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
										Discount </th>
									<th width="10%" style="font-weight:700;border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
										Total </th>
								</tr>
							</thead>
							<tbody style="font-size:11px;line-height:120%;">
								@if(count($data['orderDetail'])>0)
								@foreach($data['orderDetail'] as $key=>$value)

								<tr>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;">
									{{ isset($value->product_id) ? $value->product_id :''}}</td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;">
									{{ isset($value->item_name) ? $value->item_name :''}}</td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;">
									{{ isset($value->uom) ? $value->uom :''}}</td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
									{{ isset($value->Unit_Price) ? $value->Unit_Price :''}}</td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: center;">
									{{ isset($value->qty) ? $value->qty :''}}<br /></td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
									{{ isset($value->total_Price) ? $value->total_Price :''}}</td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
									{{ isset($value->total_discount) ? $value->total_discount :''}}</td>
									<td style="border-top:1px solid #d4cdcd;border-right:1px solid #d4cdcd;border-bottom:1px solid #d4cdcd;border-left:1px solid #d4cdcd;text-align: right;">
									{{ isset($value->total_amount) ? $value->total_amount :''}}</td>
								</tr>

								@endforeach
								@endif
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-6">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-spacer">
						<div class="spacer" style="height:30px;"></div>
					</div>
					<div class="bee-block bee-block-2 bee-divider">
						<div class="center bee-separator" style="border-top:1px solid #807D7D;width:100%;"></div>
					</div>
				</div>
			</div>
		</div>


		<div class="bee-row bee-row-7">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w7">
					<div class="bee-block bee-block-1 bee-table">
						<table style="table-layout:fixed;direction:ltr;background-color:transparent;font-family:Lato, Tahoma, Verdana, Segoe, sans-serif;font-weight:700;color:#000000;text-align:left;letter-spacing:0px;">
							<tbody style="font-size:12px;line-height:120%;">
								<tr>
									<td width='30%' style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Delivery Location </td>
									<td style="font-weight:100;border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['customerData']->address1) ? $data['customerData']->address1 :''}}, {{ isset($data['customerData']->address2) ? $data['customerData']->address2 :''}}
									</td>
								</tr>
								<tr>
									<td width='30%' style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Delivery Date</td>
									<td style="font-weight:100;border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->tentative_delivery_date) ? $data['orderHeader']->tentative_delivery_date :''}}
									</td>
								</tr>
								<tr>
									<td width='30%' style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Delivery Route</td>
									<td style="font-weight:100;border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->delivery_route_name) ? $data['orderHeader']->delivery_route_name :''}}
									</td>
								</tr>
								<tr>
									<td width='30%' style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Order Created By</td>
									<td style="font-weight:100;border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['user']->name) ? $data['user']->name :''}}
									</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="bee-block bee-block-2 bee-spacer">
						<div class="spacer" style="height:60px;"></div>
					</div>
				</div>
				<div class="bee-col bee-col-2 bee-col-w5">
					<div class="bee-block bee-block-1 bee-table">
						<table style="table-layout:fixed;direction:ltr;background-color:transparent;font-family:Lato, Tahoma, Verdana, Segoe, sans-serif;font-weight:700;color:#000000;text-align:right;letter-spacing:0px;">
							<tbody style="font-size:14px;line-height:120%;">
								<tr>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Gross Amount</td>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->net_amt) ? $data['orderHeader']->net_amt :''}}
										SAR
									</td>
								</tr>
								<tr>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Discount</td>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->total_discount) ? $data['orderHeader']->total_discount :''}} SAR
									</td>
								</tr>
								<tr>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Loyalty Discount

									</td>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->loyalty_discount) ? $data['orderHeader']->loyalty_discount :''}} SAR
									</td>
								</tr>
								<tr>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										VAT Amount</td>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->vat_amt) ? $data['orderHeader']->vat_amt :''}} SAR
									</td>
								</tr>

								<tr>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										Net Amount</td>
									<td style="border-top:1px solid #dddddd;border-right:1px solid #dddddd;border-bottom:1px solid #dddddd;border-left:1px solid #dddddd;">
										{{ isset($data['orderHeader']->total_order_value) ? $data['orderHeader']->total_order_value :''}} SAR
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-8">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-divider">
						<div class="center bee-separator" style="border-top:1px solid #807D7D;width:100%;"></div>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-9">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w12">
					<div class="bee-block bee-block-1 bee-image"><img alt="" class="bee-center bee-autowidth" src="{{ asset('/images/email/mayarimages/Untitled_1.jpg') }}" style="max-width:955px;" /></div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-10">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w3">
					<div class="bee-block bee-block-1 bee-paragraph">
						<p style="word-break: break-word;"><span><strong>Contact Us</strong></span></p>
					</div>
				</div>
				<div class="bee-col bee-col-2 bee-col-w3">
					<div class="bee-block bee-block-1 bee-paragraph">
						<p style="word-break: break-word;"><span><a href="tel:+96613845
										5555" rel="noopener" style="text-decoration: underline;" target="_blank" title="Call"><span>+96613845
										5555</span></a></span></p>
					</div>
				</div>
				<div class="bee-col bee-col-3 bee-col-w3">
					<div class="bee-block bee-block-1 bee-paragraph">
						<p style="word-break: break-word;"><a href="mailto:info@mayar.com" rel="noopener" style="text-decoration: underline;" target="_blank">info@mayar.com</a></p>
					</div>
				</div>
				<div class="bee-col bee-col-4 bee-col-w3">
					<div class="bee-block bee-block-1 bee-social">
						<div class="content"><span class="icon" style="padding:0 2.5px 0 2.5px;"><a href="https://twitter.com/MayarFoods" target="_self"><img alt="Twitter" src="{{ asset('/images/email/mayarimages/twitter2x.png') }}" title="twitter" /></a></span><span class="icon" style="padding:0 2.5px 0 2.5px;"><a href="https://www.linkedin.com/company/mayarfoods/" target="_self"><img alt="Linkedin" src="{{ asset('/images/email/mayarimages/linkedin2x.png') }}" title="linkedin" /></a></span></div>
					</div>
				</div>
			</div>
		</div>
		<div class="bee-row bee-row-11">
			<div class="bee-row-content">
				<div class="bee-col bee-col-1 bee-col-w4">
					<div class="bee-block bee-block-1 bee-paragraph">
						<p style="word-break: break-word;">Mayar Foods </p>
					</div>
				</div>
				<div class="bee-col bee-col-2 bee-col-w4">
					<div class="bee-block bee-block-1 bee-spacer">
						<div class="spacer" style="height:1px;"></div>
					</div>
				</div>
				<div class="bee-col bee-col-3 bee-col-w4">
					<div class="bee-block bee-block-1 bee-text">
						<div class="bee-text-content" style="font-size: 12px; line-height: 120%; font-family: inherit; color: #000000;">
							<p style="font-size: 12px; line-height: 14px;"> </p>
						</div>
					</div>
				</div>
			</div>
		</div>

	</div>
</body>

</html>