<!DOCTYPE html>
<html>
<head>
    <title>Image Upload</title>
</head>
<body>

<h2>Image Upload Form</h2>

@if(session('success'))
    <div style="color: green;">{{ session('success') }}</div>
@endif

@if($errors->any())
    <div style="color: red;">
        <ul>
            @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<form action="{{ route('image.upload') }}" method="post" enctype="multipart/form-data">
    @csrf

    <label for="product_id">Product ID:</label>
    <input type="text" name="product_id" required>

    <br>

    <label for="image">Select Image(s):</label>
    <input type="file" name="image[]" accept="image/*" multiple required>

    <br>

    <label for="thumb">Set as Thumbnail:</label>
    <input type="checkbox" name="thumb">

    <br>

    <button type="submit">Upload</button>
</form>

</body>
</html>
