<?php
use App\Http\Middleware\LogRoute;
use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
Route::post("/login", ["App\Http\Controllers\Api\UserController", "login"])->middleware(LogRoute::class);
Route::post("/register", ["App\Http\Controllers\Api\UserController", "register"])->middleware(LogRoute::class);
Route::apiResource('/data', App\Http\Controllers\Api\DataController::class)->middleware(LogRoute::class);
//Update Rootpro Order Id
Route::post('/update-rootpro-orderId',  ['App\Http\Controllers\Api\OrderController','updateRootproOrderId'])->middleware(LogRoute::class);
Route::get('/invoice-tax', ['App\Http\Controllers\Api\InvoiceDetailsController', 'getClearTaxInvoice'])->middleware(LogRoute::class);
Route::post('/validate-token', ['App\Http\Controllers\Api\UserController','validateToken'])->middleware(LogRoute::class);
Route::post('/update-password', ['App\Http\Controllers\Api\UserController','updateUserPassword'])->middleware(LogRoute::class);
Route::post('/get-userid', ['App\Http\Controllers\Api\UserController','getUserIdfromEmail'])->middleware(LogRoute::class);
Route::apiResource('/send/recovery/token', App\Http\Controllers\Api\EmailController::class,)->middleware(LogRoute::class);


Route::get('emailTest', ['App\Http\Controllers\Api\OrderNotificaionController', 'testEmail'])->middleware(LogRoute::class);

Route::apiResource('termsandconditions', App\Http\Controllers\Api\TermsConditionsController::class)->middleware(LogRoute::class);


Route::middleware(['static.token'])->group(function () {

    
    Route::post('/customer-store', ['App\Http\Controllers\Api\CustomersController','customerStoreFromRoutePro'])->middleware(LogRoute::class);
    Route::post('/product-store', ['App\Http\Controllers\Api\ProductController','productStoreFromRoutePro'])->middleware(LogRoute::class);
    Route::post('/order-store', ['App\Http\Controllers\Api\OrderController','orderStoreFromRoutePro'])->middleware(LogRoute::class);
    Route::post('/invoice-store', ['App\Http\Controllers\Api\InvoiceDetailsController','invoiceStoreFromRoutePro'])->middleware(LogRoute::class);
    
    Route::post('/customer-additional-details', ['App\Http\Controllers\Api\CustomersController','customerWithAdditionalDetails'])->middleware(LogRoute::class);
    Route::post('/product-additional-details', ['App\Http\Controllers\Api\ProductController','productWithAdditionalDetails'])->middleware(LogRoute::class);    
    // product-customer-pricing
    Route::post('/product-customer-pricing', ['App\Http\Controllers\Api\ProductUomCustomerMappingModelController', 'postProductUOMCUstomerMapping'])->middleware(LogRoute::class);
    // product-category-pricing
    Route::apiResource('/product-category-pricing', App\Http\Controllers\Api\ProductCategoryPriceMappingController::class)->middleware(LogRoute::class);
    Route::post('/update-order-status', ['App\Http\Controllers\Api\OrderController','updateOrderStatus'])->middleware(LogRoute::class);
    
    Route::post('/invoice-header', ['App\Http\Controllers\Api\InvoiceDetailsController', 'storeInvoiceHeader'])->middleware(LogRoute::class);
});
Route::group(["middleware" => ['jwt.auth','check.active.login']], function() {
    
    Route::apiResource('/customer', App\Http\Controllers\Api\CustomersController::class)->middleware(LogRoute::class);
    Route::apiResource('/product', App\Http\Controllers\Api\ProductController::class)->middleware(LogRoute::class);
    Route::apiResource('/order', App\Http\Controllers\Api\OrderController::class)->middleware(LogRoute::class);
    Route::apiResource('/invoice', App\Http\Controllers\Api\InvoiceDetailsController::class,)->middleware(LogRoute::class);
    Route::post("/check-user-access-limit", ["App\Http\Controllers\Api\UserController", "checkUserAccessLimit"])->middleware(LogRoute::class);
    Route::get('/product_price/{product_cat_id}/{customer}', ['App\Http\Controllers\Api\ProductUomCustomerMappingModelController', 'getByPriceGroup'])->middleware(LogRoute::class);
    Route::get('/product_price_by_user/{user_id}/{product_cat_id}/{customer}', ['App\Http\Controllers\Api\ProductUomCustomerMappingModelController', 'getByPriceGroupAndUser'])->middleware(LogRoute::class);
    Route::get('/product_price_by_customer/{customer}', ['App\Http\Controllers\Api\ProductUomCustomerMappingModelController', 'getByCustomerID'])->middleware(LogRoute::class);
    Route::get('/product_price_by_customer_and_user/{user_id}/{customer}', ['App\Http\Controllers\Api\ProductUomCustomerMappingModelController', 'getByCustomerIDandUser'])->middleware(LogRoute::class);
    Route::get('/promotion_products_by_customer/{user_id}/{customer}', ['App\Http\Controllers\Api\ProductUomCustomerMappingModelController', 'getPromotionProductsByCustomerIDandUser'])->middleware(LogRoute::class);
    Route::get('/product_price_by_uom/{customer_id}/{product_id?}', ['App\Http\Controllers\Api\ProductUomByCustomerIdController', 'getByPriceUom'])->middleware(LogRoute::class);
    Route::get('/product_view/{customer_id}/{product_id?}', ['App\Http\Controllers\Api\ProductUomByCustomerIdController', 'getProductByCustomer'])->middleware(LogRoute::class);
    Route::get('/product_view_by_user/{user_id}/{customer_id}/{product_id?}', ['App\Http\Controllers\Api\ProductUomByCustomerIdController', 'getProductByCustomerAndUser'])->middleware(LogRoute::class);
    Route::post('/store-cporder', ['App\Http\Controllers\Api\OrderController','storeOrder'])->middleware(LogRoute::class);
    
    Route::get('/order-list/{customer_id}', ['App\Http\Controllers\Api\OrderController','getOrderListByCustomer'])->middleware(LogRoute::class);
    Route::get('/latest-saved-order/{customer_id}', ['App\Http\Controllers\Api\OrderController','getLatestSavedOrderByCustomer'])->middleware(LogRoute::class);
    Route::get('/latest-saved-order-by-user/{user_id}/{customer_id}', ['App\Http\Controllers\Api\OrderController','getLatestSavedOrderByCustomerAndUser'])->middleware(LogRoute::class);
    Route::get('/cancel-order/{order_id}', ['App\Http\Controllers\Api\OrderController','cancelOrder'])->middleware(LogRoute::class);
    Route::apiResource('/order-status', App\Http\Controllers\Api\OrderstatusController::class)->middleware(LogRoute::class);
    Route::apiResource('/product-image', App\Http\Controllers\Api\ImageController::class)->middleware(LogRoute::class);
    Route::apiResource('/contract', App\Http\Controllers\Api\ContractController::class,)->middleware(LogRoute::class);
    Route::apiResource('/users', App\Http\Controllers\Api\UserController::class,)->middleware(LogRoute::class);
    Route::apiResource('/survey', App\Http\Controllers\Api\LoyaltySurveyController::class,)->middleware(LogRoute::class);
    Route::apiResource('/survey_result', App\Http\Controllers\Api\LoyatySurveyResultController::class,)->middleware(LogRoute::class);
    Route::get('/survey_for_review_by_id/{survey_result_id}', ['App\Http\Controllers\Api\LoyatySurveyResultController', 'loyatySurveyResultById'])->middleware(LogRoute::class);
    Route::get('/submitted_survey_by_id/{survey_id}', ['App\Http\Controllers\Api\LoyatySurveyResultController', 'publishedSurveys'])->middleware(LogRoute::class);
    Route::get('/survey_result_by_id/{survey_id}', ['App\Http\Controllers\Api\LoyatySurveyResultController', 'surveyResultById'])->middleware(LogRoute::class);
    Route::get('/survey_by_category/{customer_category_id}/{customer}', ['App\Http\Controllers\Api\LoyaltySurveyController', 'getSurveyByCategory'])->middleware(LogRoute::class);
    Route::apiResource('/users/image', App\Http\Controllers\Api\UserImgController::class,)->middleware(LogRoute::class);
    Route::put("/changepassword", ["App\Http\Controllers\Api\UserController", "changepassword"])->middleware(LogRoute::class);
    Route::post("/survey-image", ["App\Http\Controllers\Api\ImageController", "storeSurveyImage"])->middleware(LogRoute::class);
    Route::get("/survey-questions/{survey_id}", ["App\Http\Controllers\Api\LoyaltySurveyQuestionController", "getQuestionIds"])->middleware(LogRoute::class);
   
    Route::apiResource("/redeem", App\Http\Controllers\Api\RedeemLoyalityPointsController::class,)->middleware(LogRoute::class);
    Route::get('/redeem-by-customer/{customer}', ['App\Http\Controllers\Api\RedeemLoyalityPointsController', 'getRedeempointsByCustomer'])->middleware(LogRoute::class);
    Route::apiResource("/notification", App\Http\Controllers\Api\NotificationController::class,)->middleware(LogRoute::class);
    Route::apiResource("/notification-read", App\Http\Controllers\Api\NotificationCustomerMappingController::class,)->middleware(LogRoute::class);
    Route::get('/notification_by_catid/{cat_id}/{customer_id}', ['App\Http\Controllers\Api\NotificationController', 'getNotificationByCategory'])->middleware(LogRoute::class);
    Route::get('/document-customers', ['App\Http\Controllers\Api\DocumentController', 'getUniqueCustomer'])->middleware(LogRoute::class);
    Route::get('/document-list/{cust_id}', ['App\Http\Controllers\Api\DocumentController', 'getDocumentByCustomer'])->middleware(LogRoute::class);
    Route::get('/notification_by_customer/{cat_id}/{customer_id}', ['App\Http\Controllers\Api\NotificationController', 'getAllNotificationByCategory'])->middleware(LogRoute::class);
    Route::apiResource("/category", App\Http\Controllers\Api\CategoryController::class,)->middleware(LogRoute::class);
    Route::get('/category_by_customer/{customer}', ['App\Http\Controllers\Api\CategoryController', 'categoryByCustomer'])->middleware(LogRoute::class);
    Route::apiResource("/sub_category", App\Http\Controllers\Api\SubCategoryController::class,)->middleware(LogRoute::class);
    Route::get('/subcat_by_category/{customer}/{cat_id}', ['App\Http\Controllers\Api\SubCategoryController', 'subCatsByCat'])->middleware(LogRoute::class);
    Route::apiResource("/document", App\Http\Controllers\Api\DocumentController::class,)->middleware(LogRoute::class);
    Route::apiResource("/banner", App\Http\Controllers\Api\BannerController::class,)->middleware(LogRoute::class);
    Route::get('/delete-banner/{id}', ['App\Http\Controllers\Api\BannerController', 'deleteBanner'])->middleware(LogRoute::class);
    Route::apiResource('/soa', App\Http\Controllers\Api\SoaController::class)->middleware(LogRoute::class);
    Route::apiResource('/cart', App\Http\Controllers\Api\CartController::class)->middleware(LogRoute::class);
    Route::get('/cart-items/{user_id}/{customer_id}', ['App\Http\Controllers\Api\CartController', 'getCartItems'])->middleware(LogRoute::class);
    Route::apiResource('/order-item', App\Http\Controllers\Api\OrderItemController::class)->middleware(LogRoute::class);
    Route::post('/foc-order-items', ['App\Http\Controllers\Api\OrderItemController', 'postFocOrderItem'])->middleware(LogRoute::class);
    
    Route::get('/normal-promotions', ['App\Http\Controllers\Api\SapPromotionController', 'getNormalPromotions'])->middleware(LogRoute::class);
    Route::get('/slab-promotions', ['App\Http\Controllers\Api\SapPromotionController', 'getSlabPromotions'])->middleware(LogRoute::class);
    Route::get('/cash-promotions', ['App\Http\Controllers\Api\SapPromotionController', 'getCashDiscountPromotions'])->middleware(LogRoute::class);
    Route::get('/invoice-list/{customer_id}', ['App\Http\Controllers\Api\InvoiceDetailsController','getInvoiceListByCustomer'])->middleware(LogRoute::class);

// promotion
Route::post('/customer-promotion', ['App\Http\Controllers\Api\PromotionsController', 'getPromotion'])->middleware(LogRoute::class);
Route::post('/apply-promotions', ['App\Http\Controllers\Api\PromotionsController', 'PromotionCalculations'])->middleware(LogRoute::class);
Route::post('/reset-promotions', ['App\Http\Controllers\Api\PromotionsController', 'ResetPromotionCalculations'])->middleware(LogRoute::class);
Route::post('/product-promotions', ['App\Http\Controllers\Api\PromotionsController', 'getPromotionByProduct'])->middleware(LogRoute::class);
Route::post('/product-complete-promotions', ['App\Http\Controllers\Api\PromotionsController', 'getCompletePromotionsByProduct'])->middleware(LogRoute::class);
Route::get('/customer-promotions/{customer_id}/{promo_type?}', ['App\Http\Controllers\Api\PromotionsController', 'getCustomerPromotions'])->middleware(LogRoute::class);
Route::post('/store-order-promotions', ['App\Http\Controllers\Api\PromotionsController','storeOrderPromotions'])->middleware(LogRoute::class);Route::apiResource('/data', App\Http\Controllers\Api\DataController::class)->middleware(LogRoute::class);

// transaction
Route::get('/transactions-by-order/{order_id}', ['App\Http\Controllers\Api\TransactionController', 'getTransactionByOrder'])->middleware(LogRoute::class);
Route::get('/transactions/{order_id}/{la_id}', ['App\Http\Controllers\Api\TransactionController', 'getTransactionByProduct'])->middleware(LogRoute::class);
//promotion-banner-api
Route::get('/banner-promotions/{customer_id}', ['App\Http\Controllers\Api\PromotionsController','PromotionByCustomer'])->middleware(LogRoute::class);
 
//survey not submitted api
Route::get('/survey_not_submitted/{customer_category_id}/{customer}', ['App\Http\Controllers\Api\LoyaltySurveyController', 'getSurveyByCategoryNotSubmitted'])->middleware(LogRoute::class);
//faq-category-api
Route::apiResource('/faq-category', App\Http\Controllers\Api\QuestionCategoryMasterController::class)->middleware(LogRoute::class);
Route::get('/faq-category-status/{id}/{active}', ['App\Http\Controllers\Api\QuestionCategoryMasterController', 'UpdateStatusFaqCategory'])->middleware(LogRoute::class);
//faq-api
Route::apiResource('/faq', App\Http\Controllers\Api\FaqQuestionController::class)->middleware(LogRoute::class);
Route::get('/faq-by-id/{id}', ['App\Http\Controllers\Api\FaqQuestionController', 'getFaqById'])->middleware(LogRoute::class);
Route::get('/faq-status/{id}/{active}', ['App\Http\Controllers\Api\FaqQuestionController', 'UpdateStatusFaq'])->middleware(LogRoute::class);
//survey not submitted api
Route::get('/survey_not_submitted/{customer_category_id}/{customer}', ['App\Http\Controllers\Api\LoyaltySurveyController', 'getSurveyByCategoryNotSubmitted'])->middleware(LogRoute::class);
// payment related api
Route::apiResource('/payment', App\Http\Controllers\Api\PaymentController::class)->middleware(LogRoute::class);
Route::get('/payment-by-customer/{customer_id}', ['App\Http\Controllers\Api\PaymentController', 'paymentsByCustomer'])->middleware(LogRoute::class);
Route::get('/payment-modes', ['App\Http\Controllers\Api\PaymentController', 'paymentsModes'])->middleware(LogRoute::class);
Route::get('/payment-types', ['App\Http\Controllers\Api\PaymentController', 'paymentsTypes'])->middleware(LogRoute::class);
Route::post("/payment-image", ["App\Http\Controllers\Api\ImageController", "storePaymentImage"])->middleware(LogRoute::class);
Route::apiResource('/banks', App\Http\Controllers\Api\BankMasterController::class)->middleware(LogRoute::class);
//survey not Attended api
Route::get('/survey-not-attended/{customer_category_id}/{customer}', ['App\Http\Controllers\Api\LoyaltySurveyController', 'getSurveyByCategoryNotAttended'])->middleware(LogRoute::class);
 //Emaiil Testing
Route::post('/test_email', ['App\Http\Controllers\Api\EmailController', 'store'])->middleware(LogRoute::class);
//Product view for Nadec
Route::get('/product-detailed-view/{customer_id}/{product_id?}', ['App\Http\Controllers\Api\ProductUomByCustomerIdController', 'getProductDetailsByCustomer'])->middleware(LogRoute::class);
Route::get('/product-detailed-view-by-user/{user_id}/{customer_id}/{product_id?}', ['App\Http\Controllers\Api\ProductUomByCustomerIdController', 'getProductDetailsByCustomerAndUser'])->middleware(LogRoute::class);
//FOC products for Nadec
Route::get('/foc-products/{order_id}', ['App\Http\Controllers\Api\PromotionsController', 'getFocProducts'])->middleware(LogRoute::class);
//Re order  
Route::get('/reorder-submission/{order_id}', ['App\Http\Controllers\Api\PromotionsController', 'reorderSubmission'])->middleware(LogRoute::class);

Route::get('/cart-count/{user_id}/{customer_id}', ['App\Http\Controllers\Api\OrderItemController', 'getCountOfProductsInCart'])->middleware(LogRoute::class);

#feedback
Route::apiResource('/feedback', App\Http\Controllers\Api\FeedbackController::class)->middleware(LogRoute::class);

#profile edit request
Route::apiResource('/profile-edit-request', App\Http\Controllers\Api\ProfileEditRequestController::class)->middleware(LogRoute::class);

#Invoice list for mayar -  
Route::get('/change-profile-edit-request-status/{id}', ['App\Http\Controllers\Api\ProfileEditRequestController', 'UpdateViewOfProfileEditRequest'])->middleware(LogRoute::class);
#Invoice list for mayar - for showing in orders for particular statuses
Route::get('/invoice-list-for-order/{customer_id}', ['App\Http\Controllers\Api\InvoiceDetailsController', 'getInvoiceListByCustomerForOrder'])->middleware(LogRoute::class);

#Get Order status from sap
Route::get('/update-orderstatus-sap/{customer_id}', ['App\Http\Controllers\Api\OrderstatusController', 'getOrderStatusFromSap'])->middleware(LogRoute::class);

#Get All Orders for Admin
Route::get('/all-orders', ['App\Http\Controllers\Api\OrderController', 'getAllOrderListForAdmin'])->middleware(LogRoute::class);

#Get All Invoice for Admin
Route::get('/all-invoice', ['App\Http\Controllers\Api\InvoiceDetailsController', 'getAllInvoiceListForAdmin'])->middleware(LogRoute::class);


#Number of distinct customers using app
Route::get('/customers-using-app', ['App\Http\Controllers\Api\DashboardController', 'getCountOfCustomersUsing'])->middleware(LogRoute::class);

#Number of orders from App in last 30 days
Route::get('/orders-last-30days', ['App\Http\Controllers\Api\DashboardController', 'numberOfOrdersFromAppLast30Days'])->middleware(LogRoute::class);

#Month on month customer using app - for 6 months
Route::get('/monthonmonth-customer-6months', ['App\Http\Controllers\Api\DashboardController', 'monthOnMonthCustomer6Months'])->middleware(LogRoute::class);

#Month on month orders from App - for 6 months
Route::get('/monthonmonth-order-6months', ['App\Http\Controllers\Api\DashboardController', 'monthOnMonthOrder6Months'])->middleware(LogRoute::class);

#ordercount by status - 30days
Route::get('/ordercount-by-status-30days', ['App\Http\Controllers\Api\DashboardController', 'getOrderCountByStatusLast30Days'])->middleware(LogRoute::class);

#getRouteproToken
Route::get('/routepro-token', ['App\Http\Controllers\Api\CompanyDetailController', 'getRouteproToken'])->middleware(LogRoute::class);

Route::post('/updatetc', ['App\Http\Controllers\Api\TermsConditionsController','updateUserData'])->middleware(LogRoute::class);
});